@extends('index')
@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">
            <!-- Page Title and Breadcrumb -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">{{ $title }}</h4>
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="#">Admin</a></li>
                            <li class="breadcrumb-item active">Page Privileges</li>
                        </ol>
                    </div>
                </div>
            </div>

            <!-- Flash Messages -->
            <div class="row justify-content-center">
                <div class="col-12">
                    @include('layouts.flashmessages')
                </div>
            </div>

            <!-- Table Card -->
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="row align-items-center">
                                <div class="col">
                                    {{-- <h4 class="card-title mb-0">Teacher Privileges</h4> --}}
                                </div>
                                {{-- Add Privilege Button --}}
                                <div class="col-auto">
                                    <a href="javascript:void(0)" 
                                       onclick="basic_modal('', 'staffs/addprivilege', 'Add Privilege')" 
                                       class="waves-effect waves-light btn btn-outline btn-sm btn-primary float-end"
                                       data-bs-toggle="modal" data-bs-target="#exampleModalDefault">
                                       <i class="fas fa-plus"></i> Add Privilege
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div class="table-responsive">
                                <table class="table datatable" id="table1" width="100%">
                                    <thead class="table-light">
                                        <tr>
                                            <th>SL No</th>
                                            <th>Teacher Name</th>
                                            <th>Attendance</th>
                                            <th>Marks</th>
                                            <th>Entry Exit Card </th>
                                            <th>Health Card</th> 
                                            <th>Event</th> 
                                            <th>Leave</th> 
                                            <th>Payment</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     </div>
</div>
@endsection

@section('contentjs')
<script>
$(document).ready(function () {
    $('#table1').DataTable({
        processing: true,
        serverSide: true,
        searching: true,
        ajax: "{{ route('staffs.pageprivilegesview') }}",
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            { data: 'TTID', name: 'TTID' },
            { data: 'attendance', name: 'attendance' },
            { data: 'mark', name: 'mark' },
            { data: 'entry_exit_card', name: 'entry_exit_card'},
            { data: 'healthcard', name: 'healthcard'},
            { data: 'event', name: 'event'},
            { data: 'leave', name: 'leave'},
            { data: 'payment', name: 'payment'},
            { data: 'action', name: 'action', searchable: false, orderable: false }
        ]
    });
});
</script>
@endsection
