@extends('index')
@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                 
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">{{ $title }}</h4>
                        <div class="">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="#">Admin</a></li>
                                <li class="breadcrumb-item active">Manage Teachers</li>
                            </ol>
                        </div>                            
                    </div>
                    
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">                      
                                               @include('layouts.flashmessages')
                                            {{-- <h4 class="card-title">Class List</h4> --}}
                                                <a href="javascript:void(0)" onclick="large_modal('', 'staffs/addteacher', 'Add Teacher')" class="waves-effect waves-light btn btn-outline btn-sm btn-info
                                                 float-end" title="Add" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg"><i class="fas fa-plus"></i> Add Teacher</i></a>  
                       
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body pt-0">
                                    <div class="table-responsive">
                                        <table class="table datatable" id="example1" width="100%" style="table-layout:fixed">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>SL No</th>
                                                    <th>TTID</th>
                                                    <th>Teacher Name</th>
                                                    <th>Email Id</th>
                                                    <th>User Name</th>
                                                    <th>Subject Name</th>
                                                    <th>Location Name</th>
                                                    <th>Allotted Classes</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('contentjs')
<script>
$(document).ready(function () {
    $('#example1').DataTable({
        processing: true,
        serverSide: true,
        searching: true,
        ajax: {
            url: "{{ route('staffs.manageteachersview') }}",
            type: 'GET'
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            { data: 'TTID', name: 'TTID' },
            { data: 'Name', name: 'Name' },
            { data: 'emailId', name: 'emailId' },
            { data: 'tUsername', name: 'tUsername' },
            { data: 'TypeId', name: 'TypeId' },
            { data: 'LocId', name: 'LocId' },
            { data: 'allotted_classes', name: 'allotted_classes' },
            { data: 'action', name: 'action', searchable: false, orderable: false }
        ]
    });
    
});

</script>
@endsection