@extends('index')
@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">{{ $title }}</h4>
                        <div class="">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="#">Admin</a></li>
                                <li class="breadcrumb-item active">Student Notifications</li>
                            </ol>
                        </div>                            
                    </div>
                    
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">                      
                                            @include('layouts.flashmessages')
                                            <div class="d-flex justify-content-end gap-2">
                                                <a href= "javascript:void(0)" onclick="basic_modal('', 'notifications/addallstudnotifications', 'Push All  Notifications')" class="waves-effect waves-light btn btn-outline btn-sm btn-info 
                                                float-end" title="Add" data-bs-toggle="modal" data-bs-target="#exampleModalDefault"><i class="fas fa-plus"></i>Push All Notifications</i></a>   
                                                <a href="javascript:void(0)" onclick="basic_modal('', 'notifications/addstudclassnotifications', 'Push Individual or Classwise Notifications')" class="waves-effect waves-light btn btn-outline btn-sm btn-info 
                                                float-end" title="Add" data-bs-toggle="modal" data-bs-target="#exampleModalDefault"><i class="fas fa-plus"></i> Push Individual or Classwise Notifications</i></a>  
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body pt-0">
                                    <div class="table-responsive">
                                        <table class="table datatable" id="example3" width="100%" style="table-layout:fixed">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>SL No</th>
                                                    {{-- <th>SNID</th> --}}
                                                    <th>Student Name</th>
                                                    <th>Class</th>
                                                    <th>Section</th>
                                                    <th>All Student Wise</th>
                                                    <th>Message</th>
                                                    <th>Title</th>
                                                    <th>Notification Date</th>
                                                    {{-- <th>Actions</th> --}}
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>

                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>

                    </div>
    </div>
</div>
@endsection

@section('contentjs')
<script>
$(document).ready(function () {
    $('#example3').DataTable({
        processing: true,
        serverSide: true,
        searching: true,
        ajax: {
            url: "{{ route('notifications.studnotificationsview') }}", 
            type: 'GET'
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            // { data: 'SNID', name: 'SNID' },
            { data: 'SID', name: 'SID' },
            {data:'Class',name:'Class'},
            {data:'Sec',name:'Sec'},
            { data: 'all_stud', name: 'all_stud' },
            { data: 'Message', name: 'Message' },
            { data: 'title', name: 'title' },
            { data: 'Notftn_date', name: 'Notftn_date' },
            // { data: 'action', name: 'action', searchable: false, orderable: false }

        ]
    });
});
</script>
@endsection