@extends('index')
@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-sm-12">
                 
                    <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                        <h4 class="page-title">{{ $title }}</h4>
                        <div class="">
                            <ol class="breadcrumb mb-0">
                                <li class="breadcrumb-item"><a href="#">Admin</a></li>
                                <li class="breadcrumb-item active">Staff Notifications</li>
                            </ol>
                        </div>                            
                    </div>
                    
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col">                      
                                            @include('layouts.flashmessages')
                                               <a href="javascript:void(0)" onclick="basic_modal('', 'notifications/addstaffnotifications', 'Add Notifications')" class="waves-effect waves-light btn btn-outline btn-sm btn-info
                                                 float-end" title="Add" data-bs-toggle="modal" data-bs-target="#exampleModalDefault"><i class="fas fa-plus"></i> Add Notifications</i></a>  
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body pt-0">
                                    <div class="table-responsive">
                                        <table class="table datatable" id="example2" width="100%" style="table-layout:fixed">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>SL No</th>
                                                    {{-- <th>SNID</th> --}}
                                                    <th>Teacher Name</th>
                                                    <th>Title</th>
                                                    <th>Message</th>
                                                    <th>Notification Date</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@section('contentjs')
<script>
$(document).ready(function () {
    $('#example2').DataTable({
        processing: true,
        serverSide: true,
        searching: true,
        ajax: {
            url: "{{ route('notifications.staffnotificationsview') }}", 
            type: 'GET'
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: false, orderable: false },
            // { data: 'SNID', name: 'SNID' },
            { data: 'TTID', name: 'TTID' },
            { data: 'Title', name: 'Title' },
            { data: 'Message', name: 'Message' },
            { data: 'Notfct_date', name: 'Notfct_date' },
            { data: 'action', name: 'action', searchable: false, orderable: false }

        ]
    });
});
</script>
@endsection
