<!DOCTYPE html>
<html lang="en" dir="ltr" data-startbar="dark" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>Login | Arya Central School</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="" name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
    <link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css" />

</head>
<body>
    <div class="container-xxl">
        <div class="row vh-100 d-flex justify-content-center">
            <div class="col-12 align-self-center">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 mx-auto">
                            <div class="card">
                                <div class="card-body p-0 auth-header-box rounded-top">
                                    <div class="text-center p-4">
                                        @php
                                        $settings = \App\Models\Settings::first();
                                        @endphp

                                        <a href="#" class="logo logo-admin bg-white p-2 rounded">
                                        <img src="{{ isset($settings->main_logo) ? asset('assets/images/' . $settings->main_logo) : asset('assets/images/cropped-logo-5.png') }}" 
                                        height="50" alt="logo" class="auth-logo">
                                        </a>

                                        {{-- <h4 class="mt-3 mb-1 fw-semibold">Login</h4>    --}}
                                        {{-- <p class="text-muted fw-medium mb-0">Sign in to continue to Approx.</p>   --}}
                                    </div>
                                </div><br>
                                <div class="card-body pt-0">  
                                    <div class="res_alert"></div>                                  
                                    <form action="javascript:;" id="logInform" method="post">         
                                        <div class="form-group mb-2">
                                            <label class="form-label" for="username">Username</label>
                                            <input type="text" class="form-control" id="username" name="username" placeholder="Enter username">                               
                                        </div><!--end form-group--> 
            
                                        <div class="form-group">
                                            <label class="form-label" for="userpassword">Password</label>                                            
                                            <input type="password" class="form-control" name="password" id="password" placeholder="Enter password">                            
                                        </div><!--end form-group--> 
            
                                        <div class="form-group row mt-3">
                                            <div class="col-sm-6">
                                                <div class="form-check form-switch form-switch-success">
                                                    <input class="form-check-input" type="checkbox" id="customSwitchSuccess">
                                                    <label class="form-check-label" for="customSwitchSuccess">Remember me</label>
                                                </div>
                                            </div><!--end col--> 
                                            <div class="col-sm-6 text-end">
                                                <a href="#" class="text-muted font-13"><i class="dripicons-lock"></i> Forgot password?</a>                                    
                                            </div><!--end col--> 
                                        </div><!--end form-group--> 
            
                                        <div class="form-group mb-0 row">
                                            <div class="col-12">
                                                <div class="d-grid mt-3">
                                                    <button class="btn btn-primary signin_b" type="submit">Log In <i class="fas fa-sign-in-alt ms-1"></i></button>
                                                </div>
                                            </div>
                                        </div>                          
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>                                     
    </div>
    </body>
    <script src="{{ asset('assets/js/app.js') }}"></script>
    <script src="{{ asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/libs/simplebar/simplebar.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery-3.7.1.min.js') }}"></script>

    <script>
        $(document).ready(function(){
            $('#logInform').on('submit', function(e){
              var button_text = $(".signin_b").html();
              $(".signin_b").html('<i class="fa fa-circle-o-notch fa-spin"></i> loading...');
              $(".signin_b").prop( "disabled", true );
                var username = $("#username").val();
                var password = $("#password").val();
                // alert(password);
            $.post("{{route('dologin')}}",{ 'email':username,'password':password,'_token':'{{csrf_token()}}'})
                    .done(function(data){
                    //   alert(data);
                        if (data.msg == 'invalid') {
                          $(".signin_b").html(button_text);
                  $(".signin_b").prop( "disabled",false);
                            $(".res_alert").html('<p class="text-dark text-center alert alert-danger" role="alert">Username or password wrong!</p>');
                        }
                        if(data.msg == 'success'){
                            $(".res_alert").html('<p class="text-dark text-center alert alert-success" role="alert">You successfully logged in</p>');
                          location.reload();
                        }
                    })
            });
        });
      </script>
</html>