<?php

namespace App\Http\Controllers;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\PushMail;

use App\Models\User;
use App\Models\Slogin;
use App\Models\Stafflogin;

use PDF;


class Apicontroller extends Controller
{
    public function index()
    {
        return response()->json([
            'status' => 'success',
            'msg' => env('APP_NAME').' Server Running',
            'data' => ''
        ], 200);
    }
    public function login(Request $req)
    {
        $username = $req->post('username');
        $password = $req->post('password');
        if (empty($username) || empty($password)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $userdata = array(
            'email' => $req->post('username'),
            'password' => $req->post('password')
        );
        if ($userdata) {
            $username = $userdata['email'];
            $password = $userdata['password'];
            $studentProfile = DB::table('app_studprofile')->where('username', $username)->first();
            // echo '<pre>';print_r($studentProfile);die();
            if ($studentProfile && $studentProfile->password == $password) {
                if ($studentProfile->status == 2) {
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'inactive',
                        'data' => ''
                    ], 200);
                }
                $studentProfile->userType ='s';
                $filteredProfile = (object) [
                    'ID' => $studentProfile->SID,
                    'Name' => $studentProfile->Name,
                    'Gender' => $studentProfile->Gender,
                    'MobNo' => $studentProfile->MobNo,
                    'MailId' => $studentProfile->MailId,
                    'Class' => $studentProfile->Class,
                    'Section' => $studentProfile->Section,
                    'username' => $studentProfile->username,
                    'userType' => $studentProfile->userType,
                    'pageprivilages' =>[
                                'attendance_view' => 1,
                                'attendance_edit' => 0,
                                'mark_edit' => 0,
                                'mark_view' => 1,
                                'entry_exit_card_edit' => 0,
                                'entry_exit_card_view' => 1,
                                'healthcard_edit' => 0,
                                'healthcard_view' => 1,
                                'event_edit' => 0,
                                'event_view' => 1,
                                'leave_edit' => 0,
                                'leave_view' => 0,
                                'payment_edit' => 0,
                                'payment_view' => 1
                            ]
                ];
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Login successfully',
                    'data' => $filteredProfile
                ], 200);
            }
            $staffProfile = DB::table('app_staffprofile')->where('username', $username)->first();
            if ($staffProfile && $staffProfile->password == $password) {
                if ($staffProfile->status == 2) {
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'inactive',
                        'data' => ''
                    ], 200);
                }
                 if ($staffProfile->userType == 'u') {
                    $app_pageprivilages = DB::table('app_pageprivilages')->where('STID',$staffProfile->STID)->first();
                    $filteredStaffProfile = (object) [
                        'ID' => $staffProfile->STID,
                        'Name' => $staffProfile->Name,
                        'Gender' => $staffProfile->Gender,
                        'MobNo' => $staffProfile->MobNo,
                        'MailId' => $staffProfile->MailId,
                        'username' => $staffProfile->username,
                        'userType' => $staffProfile->userType,
                        'pageprivilages' =>[
                                'attendance_view'         => isset($app_pageprivilages->attendance_view) ? $app_pageprivilages->attendance_view : 0,
                                'attendance_edit'         => isset($app_pageprivilages->attendance_edit) ? $app_pageprivilages->attendance_edit : 0,
                                'mark_edit'               => isset($app_pageprivilages->mark_edit) ? $app_pageprivilages->mark_edit : 0,
                                'mark_view'               => isset($app_pageprivilages->mark_view) ? $app_pageprivilages->mark_view : 0,
                                'entry_exit_card_edit'    => isset($app_pageprivilages->entry_exit_card_edit) ? $app_pageprivilages->entry_exit_card_edit : 0,
                                'entry_exit_card_view'    => isset($app_pageprivilages->entry_exit_card_view) ? $app_pageprivilages->entry_exit_card_view : 0,
                                'healthcard_edit'         => isset($app_pageprivilages->healthcard_edit) ? $app_pageprivilages->healthcard_edit : 0,
                                'healthcard_view'         => isset($app_pageprivilages->healthcard_view) ? $app_pageprivilages->healthcard_view : 0,
                                'event_edit'              => isset($app_pageprivilages->event_edit) ? $app_pageprivilages->event_edit : 0,
                                'event_view'              => isset($app_pageprivilages->event_view) ? $app_pageprivilages->event_view : 0,
                                'leave_edit'              => isset($app_pageprivilages->leave_edit) ? $app_pageprivilages->leave_edit : 0,
                                'leave_view'              => isset($app_pageprivilages->leave_view) ? $app_pageprivilages->leave_view : 0,
                                'payment_edit'            => isset($app_pageprivilages->payment_edit) ? $app_pageprivilages->payment_edit : 0,
                                'payment_view'            => isset($app_pageprivilages->payment_view) ? $app_pageprivilages->payment_view : 0
                            ]
                    ];
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'Login successfully',
                        'data' => $filteredStaffProfile
                    ], 200);
                }
            }
            $teacherprofile = DB::table('app_teacherprofile')->where('tUsername', $username)->first();
            if ($teacherprofile && $teacherprofile->tPwd == $password) {
                if ($teacherprofile->status == 2) {
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'inactive',
                        'data' => ''
                    ], 200);
                }
                 if ($teacherprofile->userType == 'u') {
                    $app_pageprivilages = DB::table('app_pageprivilages')->where('TTID',$teacherprofile->TTID)->first();
                    $filteredteacherProfile = (object) [
                        'ID' => $teacherprofile->TTID,
                        'Name' => $teacherprofile->Name,
                        'Gender' => $teacherprofile->Class,
                        'MobNo' => $teacherprofile->Sec ,
                        'MailId' => $teacherprofile->emailId,
                        // 'MailId' => $teacherprofile->TypeId,
                        'username' => $teacherprofile->tUsername,
                        'userType' => $teacherprofile->tPwd,
                        'pageprivilages' =>[
                                'attendance_view'         => isset($app_pageprivilages->attendance_view) ? $app_pageprivilages->attendance_view : 0,
                                'attendance_edit'         => isset($app_pageprivilages->attendance_edit) ? $app_pageprivilages->attendance_edit : 0,
                                'mark_edit'               => isset($app_pageprivilages->mark_edit) ? $app_pageprivilages->mark_edit : 0,
                                'mark_view'               => isset($app_pageprivilages->mark_view) ? $app_pageprivilages->mark_view : 0,
                                'entry_exit_card_edit'    => isset($app_pageprivilages->entry_exit_card_edit) ? $app_pageprivilages->entry_exit_card_edit : 0,
                                'entry_exit_card_view'    => isset($app_pageprivilages->entry_exit_card_view) ? $app_pageprivilages->entry_exit_card_view : 0,
                                'healthcard_edit'         => isset($app_pageprivilages->healthcard_edit) ? $app_pageprivilages->healthcard_edit : 0,
                                'healthcard_view'         => isset($app_pageprivilages->healthcard_view) ? $app_pageprivilages->healthcard_view : 0,
                                'event_edit'              => isset($app_pageprivilages->event_edit) ? $app_pageprivilages->event_edit : 0,
                                'event_view'              => isset($app_pageprivilages->event_view) ? $app_pageprivilages->event_view : 0,
                                'leave_edit'              => isset($app_pageprivilages->leave_edit) ? $app_pageprivilages->leave_edit : 0,
                                'leave_view'              => isset($app_pageprivilages->leave_view) ? $app_pageprivilages->leave_view : 0,
                                'payment_edit'            => isset($app_pageprivilages->payment_edit) ? $app_pageprivilages->payment_edit : 0,
                                'payment_view'            => isset($app_pageprivilages->payment_view) ? $app_pageprivilages->payment_view : 0
                            ]
                    ];
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'Login successfully',
                        'data' => $filteredteacherProfile
                    ], 200);
                }
            }
            return response()->json([
                'status' => 'error',
                'msg' => 'User not found or incorrect password',
                'data' => ''
            ], 200);
        }
    }
    public function pwdResetOtp($username)
    {
        // $check_mob = DB::table('app_studprofile')->where('username', $username)->first();
        // if (empty($check_mob)) {
        //     return response()->json([
        //         'status' => 'error',
        //         'msg' => 'Student not found',
        //         'data' => null
        //     ], 200);
        // }
        // $data['static_otp'] = $static_otp = rand(1000, 9999);
        // if (empty($check_mob->MailId) && empty($check_mob->MEmail)) {
        //     return response()->json([
        //         'status' => 'error',
        //         'msg' => 'No email found, update your profile first',
        //         'data' => null
        //     ], 200);
        // }
        // $emailData = [
        //         'name' => $check_mob->Name,
        //         'static_otp' => $static_otp
        //     ];
        // if (!empty($check_mob->MailId)) {
        //     Mail::to($check_mob->MailId)->send(new PushMail($emailData));
        // } elseif (!empty($check_mob->MEmail)) {
        //     Mail::to($check_mob->MEmail)->send(new PushMail($emailData));
        // }
        // $data['check_mob'] = $check_mob;

        // return response()->json([
        //     'status' => 'success',
        //     'msg' => 'Otp sent successfully',
        //     'data' => $data
        // ], 200);
        
        // $students = DB::table('app_studprofile')->where('Class','LIKE', 'XI')->where('Section','LIKE', 'A')->get();
        $students = DB::table('app_studprofile')->where('Class','LIKE', 'VI')->get();
        echo $students->count().'<br>';
        $count = 1;
        foreach($students as $s){
            $class = DB::table('app_classname')->where('className',$s->Class)->first();
            $examRes = DB::table('app_stud_marks_details')->where('studId',$s->SID)->update(['classId' => $class->classId]);
            print_r($examRes);echo '----'.$count++.'<br>';
        }
    }
    public function otpValidateNewpwd(Request $req)
    {
        $user_id = $req->post('user_id');
        $newpassword = $req->post('newpassword');
        if (empty($newpassword) || empty($user_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => null
            ], 200);
        } else {
            $student = DB::table('app_studprofile')->where('SID', $user_id)->first();
            if (empty($student)) {
                return response()->json([
                    'status' => 'error',
                    'msg' => 'Student not found',
                    'data' => null
                ], 200);
            }
            DB::table('app_studprofile')->where('SID', $user_id)->update(['password' => $newpassword]);

            $student = DB::table('app_studprofile')->where('SID', $user_id)->first();
            $data['student'] = $student;

            return response()->json([
                'status' => 'success',
                'msg' => 'Password updated successfully',
                'data' => $data
            ], 200);
        }
        // echo '<pre>';print_r($_POST);die();
    }
    public function count_row($table_name ='')
    {
        if (empty($table_name)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }

        $res = DB::table($table_name)->count();
        return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $res
        ], 200);
    }
    public function notif_view(Request $req)
    {
        $all = $req->post('all');
        if (!empty($all)) {
            $rest = DB::table('app_studnotification')->where('all_stud', $all)->orderBy('NID', 'desc')->get();
            $staffs = [];
            $teachers = [];
            foreach ($rest as $key => $value) {
                if ($value->staff_id != '') {
                    $tid = $value->staff_id ;
                    $staff = DB::table('app_staffprofile')->select('Name')->where('STID', $value->staff_id)->first();
                    $teacher = DB::table('app_teacherprofile')->select('Name')->where('TTID', $value->staff_id)->first();
                }
                if ($staff) {
                        $value->staff_name = $staff->Name;
                        $staffs[] = $staff->Name;
                    }
                    if ($teacher) {
                        $value->staff_names = $teacher->Name;
                        $teachers[] = $teacher->Name;
                    }
            }
           return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $rest
        ], 200);
        }else{
            $rest = DB::table('app_studnotification')->where('all_stud', '!=', 1)->orderBy('NID', 'desc')->get();
            $students = [];
            $staffs = [];
            $teachers = [];
            foreach ($rest as $key => $value) {
                if ($value->SID != '') {
                    $sid = $value->SID ;
                    $student = DB::table('app_studprofile')->select('Name','Class','Section')->where('SID', $value->SID)->first();
                    $staff = DB::table('app_staffprofile')->select('Name')->where('STID', $value->staff_id)->first();
                    $teacher = DB::table('app_teacherprofile')->select('Name')->where('TTID', $value->staff_id)->first();
                    if ($student) {
                        $value->Name = $student->Name;
                        $value->Classes = $student->Class;
                        $value->Sections = $student->Section;
                        $students[] = $student->Name;
                    }
                    if ($staff) {
                        $value->staff_name = $staff->Name;
                        $staffs[] = $staff->Name;
                    }
                    if ($teacher) {
                        $value->staff_names = $teacher->Name;
                        $teachers[] = $teacher->Name;
                    }
                } else{
                    $staff = DB::table('app_staffprofile')->select('Name')->where('STID', $value->staff_id)->first();
                    $teacher = DB::table('app_teacherprofile')->select('Name')->where('TTID', $value->staff_id)->first();
                    if ($staff) {
                        $value->staff_name = $staff->Name;
                        $staffs[] = $staff->Name;
                    }
                    if ($teacher) {
                        $value->staff_names = $teacher->Name;
                        $teachers[] = $teacher->Name;
                    } 
                }
            }
            return response()->json([
                'status' => 'success',
                'msg' => 'get data',
                'data' => $rest
            ], 200);
        }
    }
    public function stud_notification(Request $req)
    {
        $id = $req->post('id');
        $Class = $req->post('Class');
        $Sec = $req->post('Sec');
        $all = $req->post('all');
        $studId = $req->post('studId');
        if (empty($Class)  && empty($Sec) &&  empty($id) &&  empty($all) && empty($studId))
        {
         return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        if (!empty($studId)) {
            $studentId = trim($studId);
            $notifications = DB::table('app_studnotification')
    ->whereRaw("FIND_IN_SET(?, REPLACE(SID, ' ', '')) > 0", [$studentId])
    ->orderBy('NID', 'desc')
    ->get();
            $students = [];
            foreach ($notifications as $notification) {
                $notificationIds = explode(',', $notification->viewed_ids);
                $notificationIds = array_map('trim', $notificationIds);
                $notification->viewed_status = in_array($studentId, $notificationIds) 
                    ? 'viewed' 
                    : 'Not viewed';
                $student = DB::table('app_studprofile')
                    ->select('Name')
                    ->where('SID', $studentId)
                    ->first();
                if ($student) {
                    $notification->Name = $student->Name;
                    $students[] = $student->Name;
                }
            }
            return response()->json([
                'status' => 'success',
                'msg' => 'get data',
                'data' => $notifications
            ], 200);
        }
        if ($id) {
            $res = $data = DB::table('app_studnotification')->where('SID', $id)->orderBy('NID', 'desc')->get();
            $students = [];
            foreach ($res as $values) {
                if ($values->viewed_ids == $studId) {
                    $values->viewed_ids = 'viewed';
                } else {
                    $values->viewed_ids = 'Not viewed';
                }
                $student = DB::table('app_studprofile')->select('Name')->where('SID', $values->SID)->first();
                if ($student) {
                    $values->Name = $student->Name;
                    $students[] = $student->Name;
                }
            }

           return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $res
        ], 200);
           // print_r($res);die;
        }
        if ($all) {
           $rest = DB::table('app_studnotification')->where('all_stud', $all)->orderBy('NID', 'desc')->get();
           foreach ($rest as $values) {
                if (in_array($studId, explode(',', $values->viewed_ids))) {
                    $values->viewed_ids = 'viewed';
                } else {
                    $values->viewed_ids = 'Not viewed';
                }
            }
           return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $rest
        ], 200);
           // print_r($res);die;
        }
        $res = DB::table('app_studnotification')->where('Class', $Class)->where('Sec', $Sec)->orderBy('NID', 'desc')->get()->toArray();
        // print_r($res);die;
        if ($res) {
            foreach ($res as $values) {
                if (in_array($studId, explode(',', $values->viewed_ids))) {
                    $values->viewed_ids = 'viewed';
                } else {
                    $values->viewed_ids = 'Not viewed';
                }
            }
                return response()->json([
                'status' => 'success',
                'msg' => 'get data',
                'data' => $res
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no matching datas found',
                'data' => ''
            ], 200);
        }
    }
    public function tables_list()
    {
        $tables = DB::select('SHOW TABLES');
        $tableNames = array_map('current', $tables);
        $count = count($tableNames);
        return response()->json([
            'status' => 'success',
            'msg' => 'successfully fetched tables',
            'data' => $tableNames,$count
        ], 200);
    }
    public function get_table(Request $req)
    {
        if (empty($req->post('tablename'))) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }

        $res = DB::table($req->get('tablename'))->get();
        return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $res
        ], 200);
    }
    public function del_row($table_name='',$id='',$column_name='')
    {
        if (empty($table_name) || empty($id) || empty($column_name)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        
        $res = DB::table($table_name)->where($column_name, $id)->delete();
        if ($res) {
            return response()->json([
                'status' => 'success',
                'msg' => 'delete successfully',
                'data' => ''
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no data found',
                'data' => ''
            ], 200);
        }
    }

    public function get_table_condition(Request $req)
    {
        if (empty($req->post('tablename'))&&empty($req->post('where'))&&empty($req->post('value'))) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }

        $res = DB::table($req->post('tablename'))->where($req->post('where'),$req->post('value'))->get();
        return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'data' => $res
        ], 200);
    }
    public function get_student_list(Request $req)
    {
        $Sec = $req->post('Sec');
        $Class = $req->post('Class');
        if (empty($Sec) && empty($Class)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $res = DB::table('app_studprofile')->select('Name')->where('status', 1)->where('Class', $Class)->where('Section', $Sec)->get();
        if (!$res->isEmpty()) {
                return response()->json([
                'status' => 'success',
                'msg' => 'get data',
                'data' => $res
            ], 200);
        } else{
            return response()->json([
                'status' => 'error',
                'msg' => 'no matching data found',
                'data' => ''
            ], 200);
        }

    }
    public function parent_att_view(Request $req)
    {
        $date = $req->post('date');
        $student_id = $req->post('student_id');
        if (empty($date) || empty($student_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $attendanceData = DB::table('app_studattendence')->where('AttDate', $date)->where('SID', $student_id)->get()->toArray();
        
        $students = [];
            foreach ($attendanceData as $values) {
                $student = DB::table('app_studprofile')->select('Name')->where('status', 1)->where('SID', $values->SID)->first();
                if ($student) {
                    $values->Name = $student->Name;
                    $students[] = $student->Name;
                }
            }
            // print_r($attendanceData);die;
        if (!empty($attendanceData)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $attendanceData
            ], 200);
        } else{
            return response()->json([
                'status' => 'success',
                'msg' => 'Holyday',
                'data' => ''
            ], 200);
        }       
    }
    public function view_absenties(Request $req)
    {
        $date = $req->post('date');
        $class = $req->post('class');
        $section = $req->post('section');
        $period = $req->post('period');
        if (empty($date) || empty($class) || empty($section) || empty($period)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $hollyday = DB::table('app_studattendence')->select('AID','SID','class','Sec','AttDate',$period)->where('AttDate', $date)->where('class', $class)->where('Sec', $section)->count();
        if ($hollyday == 0) {
            return response()->json([
                'status' => 'error',
                'msg' => 'hollyday',
                'data' => ''
            ], 200);
        }
            // print_r($hollyday);die;
        
        $attendanceData = DB::table('app_studattendence')->select('AID','SID','class','Sec','AttDate',$period)->where('AttDate', $date)->where($period,'=','absent')->where('class', $class)->where('Sec', $section)->get()->toArray();
        $students = [];
            foreach ($attendanceData as $values) {
                $student = DB::table('app_studprofile')->select('Name')->where('SID', $values->SID)->where('status',1)->first();
                if ($student) {
                    $values->Name = $student->Name;
                    $students[] = $student->Name;
                }
            }
        if ($attendanceData) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $attendanceData
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no matching data found',
                'data' => ''
            ], 200);
        }
    }
    public function present_view(Request $req)
    {
        $date = $req->post('date');
        $class = $req->post('class');
        $section = $req->post('section');
        $period = $req->post('period');
        if (empty($date) || empty($class) || empty($section) || empty($period)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $hollyday = DB::table('app_studattendence')->select('AID','SID','class','Sec','AttDate',$period)->where('AttDate', $date)->where('class', $class)->where('Sec', $section)->count();
        if ($hollyday == 0) {
            return response()->json([
                'status' => 'error',
                'msg' => 'hollyday',
                'data' => ''
            ], 200);
        }
            // print_r($hollyday);die;
        
        $attendanceData = DB::table('app_studattendence')->select('AID','SID','class','Sec','AttDate',$period)->where('AttDate', $date)->where($period,'=','Present')->where('class', $class)->where('Sec', $section)->get()->toArray();
        $students = [];
            foreach ($attendanceData as $values) {
                $student = DB::table('app_studprofile')->select('Name')->where('SID', $values->SID)->where('status',1)->first();
                if ($student) {
                    $values->Name = $student->Name;
                    $students[] = $student->Name;
                }
            }
        if (!empty($attendanceData)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $attendanceData
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no matching data found',
                'data' => ''
            ], 200);
        }
    }
    public function attendance_date_filter(Request $req)
    {
        $from_date = $req->post('from_date');
        $to_date = $req->post('to_date');
        if (empty($from_date) || empty($to_date)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        if (!empty($from_date) && !empty($to_date)) {
            $attendanceData = DB::table('app_studattendence')->where('AttDate', '>=', $from_date)->where('AttDate', '<=', $to_date)->get()->toArray();
                // print_r($attendanceData);die;
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $attendanceData
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no data found',
                'data' => ''
            ], 200);
        }
        
    }
    public function class_sec_dropdown(Request $req)
    {
        $res = DB::table('app_classdivdetails')->join('app_classname', 'app_classdivdetails.classId', '=', 'app_classname.classId')->select('app_classname.className','app_classdivdetails.secName')->get();
        if (!empty($res)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $res
            ], 200);
        } 
       
    }
    public function class(Request $req)
    {
        $teacher_id = $req->post('teacher_id');
        if (empty($teacher_id)){
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else{
            $tech_class = DB::table('app_teacherprofile')->where('TTID',$teacher_id)->value('tech_class');
            if (empty($tech_class)){
                    return response()->json([
                        'status' => 'error',
                        'msg' => 'No classes Assigned ',
                        'data' => ''
                    ], 200);
                } else {
                $class_data = json_decode($tech_class, true);  
                $class_ids = array_unique(array_column($class_data, 'class'));
                // echo '<pre>';print_r($tech_class);die();
                $res = DB::table('app_classname')->whereIn('classId', $class_ids)->select('classId', 'className')->get();
            
                if ($res->isNotEmpty()) { // Better check for collection
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'success',
                        'data' => $res
                    ], 200);
                } else {
                    return response()->json([
                        'status' => 'error',
                        'msg' => 'No classes found',
                        'data' => ''
                    ], 200);
                }
            }
        }
       
    }
    public function section(Request $req)
    {
        if (empty($req->post('classId')) || empty($req->post('teacher_id'))) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else {
            $tech_class = DB::table('app_teacherprofile')->where('TTID',$req->post('teacher_id'))->value('tech_class');
            if (empty($tech_class)){
                    return response()->json([
                        'status' => 'error',
                        'msg' => 'No classes and Sections Assigned ',
                        'data' => ''
                    ], 200);
                } else {
                $class_data = json_decode($tech_class, true); 
                $class_ids = array_unique(array_column($class_data, 'class'));
                $requestedClassId = $req->post('classId');
                
                if (in_array($requestedClassId, $class_ids)) {
                    $availableDivisions = array_column(
                        array_filter($class_data, function($item) use ($requestedClassId) {
                            return $item['class'] === $requestedClassId;
                        }),
                        'division'
                    );
                    $res = DB::table('app_classdivdetails')
                        ->where('classId', $requestedClassId)
                        ->whereIn('secId', $availableDivisions)
                        ->select('secName', 'secId')
                        ->get();
                        
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'Data retrieved successfully',
                        'data' => $res
                    ], 200);  
                } else {
                    return response()->json([
                        'status' => 'error',
                        'msg' => 'Class ID not found in available classes',
                        'available_classes' => $class_ids
                    ], 404);
                }   
            }
        }
    }
    public function notification_manage(Request $req)
    {
        $SID = $req->post('SID');
        $Class = $req->post('Class');
        $Sec = $req->post('Sec');
        $all_stud = $req->post('all_stud');
        $Message = $req->post('Message');
        $title = $req->post('title'); 
        $Notftn_date = $req->post('Notftn_date');
        $staff_id = $req->post('staff_id');  
        if (empty($Message) || empty($title) || empty($Notftn_date)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $latestNID = DB::table('app_studnotification')->max('NID');
        $numericNID = intval(substr($latestNID, 3));
        $newNID = 'NID' . sprintf("%02d", $numericNID + 1);
        while (DB::table('app_studnotification')->where('NID', $newNID)->exists()) {
            $numericNID++; 
            $newNID = 'NID' . sprintf("%02d", $numericNID + 1);
        }
        if ($SID && $Message && $Notftn_date && $title) {
            $data = [
                'NID' => $newNID,
                'SID' => $SID,
                'Message' => $Message,
                'title' => $title,
                'Notftn_date' => $Notftn_date,
                'staff_id' => $staff_id,
            ];
            DB::table('app_studnotification')->insert($data);
                return response()->json([
                'status' => 'success',
                'msg' => 'inserted successfully',
                'data' => ''
            ], 200);
        } elseif ($all_stud) {
            $data = [
                'NID' => $newNID,
                'all_stud' => $all_stud,
                'Message' => $Message,
                'title' => $title,
                'Notftn_date' => $Notftn_date,
                'staff_id' => $staff_id,
            ];
            DB::table('app_studnotification')->insert($data);
                return response()->json([
                'status' => 'success',
                'msg' => 'inserted successfully',
                'data' => ''
            ], 200); 
        } else {
           $data = [
                'NID' => $newNID,
                'Class' => $Class,
                'Sec' => $Sec,
                'Message' => $Message,
                'title' => $title,
                'Notftn_date' => $Notftn_date,
                'staff_id' => $staff_id,
            ];
            DB::table('app_studnotification')->insert($data);
                return response()->json([
                'status' => 'success',
                'msg' => 'inserted successfully',
                'data' => ''
            ], 200); 
        }
    }
    public function notification_manage_teacher(Request $req)
    {
        $TTID = $req->post('TTID');
        $Message = $req->post('Message'); 
        $Notfct_date = $req->post('Notfct_date'); 
        if (empty($TTID) || empty($Message) || empty($Notfct_date)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $latestSNID = DB::table('app_staffnotification')->max('SNID');
        $numericSNID = intval(substr($latestSNID, 4));
        $newSNID = 'SNID' . sprintf("%02d", $numericSNID + 1);
        while (DB::table('app_staffnotification')->where('SNID', $newSNID)->exists()) {
            $numericSNID++; 
            $newSNID = 'SNID' . sprintf("%02d", $numericSNID + 1);
        }
        // print_r($newSNID);die;
        if ($TTID && $Message && $Notfct_date) {
            $data = [
                'SNID' => $newSNID,
                'TTID' => $TTID,
                'Message' => $Message,
                'Notfct_date' => $Notfct_date,
            ];
            // print_r($data);die;
            DB::table('app_staffnotification')->insert($data);
                return response()->json([
                'status' => 'success',
                'msg' => 'inserted successfully',
                'data' => ''
            ], 200);
        }  
    }
    public function submit_std_attendance(Request $req)
    {
        $AttDate = $req->post('AttDate');
        $class = $req->post('class');
        $Sec = $req->post('Sec');
        $Period = $req->post('Period'); 
        $TTID = $req->post('TTID');
        if (empty($AttDate) || empty($class) || empty($Sec)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $Present = $req->post('Present');
        if (strpos($Present, '"') !== false) {
            $Present = str_replace('"', '', $Present);
        }
        $result = explode(',', $Present);

        $Absent = $req->post('Absent');
        if (strpos($Absent, '"') !== false) {
            $Absent = str_replace('"', '', $Absent);
        }
        $results = explode(',', $Absent); 

          
        // print_r($result);die;

        $latestAID = DB::table('app_studattendence')->max('AID');
        $numericAID = intval(substr($latestAID, 3));

        foreach ($result as $key => $values) {
            $existingAID = DB::table('app_studattendence')->where('SID', $values)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->first();
            $data = [
                'AttDate' => $AttDate,
                'class' => $class,
                'Sec' => $Sec,
                'SID' => $values,
                'TTID' => $TTID,
                $Period => 'Present',
            ];
            // print_r($existingAID);die;
            if ($existingAID) {
                $data['AID'] = $existingAID->AID;
                DB::table('app_studattendence')->where('SID', $values)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->update($data);
            } else {
                $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                while (DB::table('app_studattendence')->where('AID', $newAID)->exists()) {
                    $numericAID++; 
                    $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                }
                $data['AID'] = $newAID;
                DB::table('app_studattendence')->insert($data);

                $numericAID++;
            }
        }
        if (filled($results)) {
            foreach ($results as $key => $values) {
                $existingAID = DB::table('app_studattendence')->where('SID', $values)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->first();
                $data = [
                    'AttDate' => $AttDate,
                    'class' => $class,
                    'Sec' => $Sec,
                    'SID' => $values,
                    'TTID' => $TTID,
                    $Period => 'Absent',
                ];
                if ($values) {
                    if ($existingAID) {
                        $data['AID'] = $existingAID->AID;
                        DB::table('app_studattendence')->where('SID', $values)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->update($data);
                    } else {
                        $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                        while (DB::table('app_studattendence')->where('AID', $newAID)->exists()) {
                            $numericAID++; 
                            $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                        }
                        $data['AID'] = $newAID;
                        DB::table('app_studattendence')->insert($data);

                        $numericAID++;
                    }
                }
            }
        }
        return response()->json([
            'status' => 'success',
            'msg' => 'inserted successfully',
            'data' => ''
        ], 200);

    }
   public function submit_attendance(Request $req)
   {
        $AttDate = $req->post('AttDate');
        $class = $req->post('class');
        $Sec = $req->post('Sec');
        $Period = $req->post('Period'); 
        if (empty($AttDate) || empty($class) || empty($Sec)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
         $attendanceData = json_decode($req->post('attendance'), true);
        // Retrieve the latest 'AID' value
        $latestAID = DB::table('app_studattendence')->max('AID');
        // Extract the numeric portion from the 'AID' value
        $numericAID = intval(substr($latestAID, 3));
        foreach ($attendanceData as $key => $values) {
            $existingAID = DB::table('app_studattendence')->where('SID', $key)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->first();
            $data = [
                'AttDate' => $AttDate,
                'class' => $class,
                'Sec' => $Sec,
                'SID' => $key,
                $Period => $values,
            ];
            if ($existingAID) {
                $data['AID'] = $existingAID->AID;
                DB::table('app_studattendence')->where('SID', $key)->where('AttDate', $AttDate)->where('class', $class)->where('Sec', $Sec)->update($data);
            } else {
                $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                // Check if the new 'AID' is already present
                while (DB::table('app_studattendence')->where('AID', $newAID)->exists()) {
                    $numericAID++; // Increment the numeric portion
                    $newAID = 'AID' . sprintf("%02d", $numericAID + 1);
                }
                $data['AID'] = $newAID;
                DB::table('app_studattendence')->insert($data);

                $numericAID++;
            }
        }
        return response()->json([
            'status' => 'success',
            'msg' => 'inserted successfully',
            'data' => ''
        ], 200);
   }  

    public function student_list(Request $req)
    {
        $class = $req->post('class');
        $section = $req->post('section');
        if (empty($class) || empty($section)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $student_list = DB::table('app_studprofile')->select('SID','Name','Class','Section','AdmsNo')->where('status', 1)->where('Class', $class)->where('Section', $section)->get()->toArray();
        if (!empty($student_list)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $student_list
            ], 200);
        } else{
            return response()->json([
                'status' => 'success',
                'msg' => 'no matching data found',
                'data' => ''
            ], 200);
        }       
    } 
    public function student_list1(Request $req)
    {
        $class = $req->post('class');
        $section = $req->post('section');
        $period = $req->post('period');
        $date = $req->post('date');
        if (empty($class) || empty($section) || empty($period) || empty($date)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $student_list = DB::table('app_studprofile')
        ->select('SID', 'Name', 'Class', 'Section', 'AdmsNo', 'rollno')
        ->where('status', 1)
        ->where('Class', $class)
        ->where('Section', $section)
        ->orderBy('rollno', 'asc')
        ->get()
        ->toArray();
        // echo '<pre>';print_r($student_list);die();  
        foreach ($student_list as $student) {
            $attendance = DB::table('app_studattendence')
                ->select('p1','p2','p3','p4','p5','p6','p7','p8','p9')
                ->where('SID', $student->SID)
                ->where('AttDate', $date)
                ->where('class', $class)
                ->where('Sec', $section)
                ->first();
            $student->p1 = $attendance ? $attendance->p1 : 'nm';
            $student->p2 = $attendance ? $attendance->p2 : 'nm'; 
            $student->p3 = $attendance ? $attendance->p3 : 'nm'; 
            $student->p4 = $attendance ? $attendance->p4 : 'nm'; 
            $student->p5 = $attendance ? $attendance->p5 : 'nm'; 
            $student->p6 = $attendance ? $attendance->p6 : 'nm'; 
            $student->p7 = $attendance ? $attendance->p7 : 'nm'; 
            $student->p8 = $attendance ? $attendance->p8 : 'nm'; 
            $student->p9 = $attendance ? $attendance->p9 : 'nm'; 
        }
        // $student_list = DB::table('app_studprofile')->select('SID','Name','Class','Section','AdmsNo','rollno')->where('status', 1)->where('Class', $class)->where('Section', $section)->orderBy('rollno', 'asc')->get()->toArray();
        // foreach($student_list as $list){
        //     $data = DB::table('app_studattendence')->select('p1')->where('AttDate', $date)->where('class', $class)->where($period, 'Present')->where('Sec', $section)->first();
        // }
        $attendance = DB::table('app_studattendence')->where('AttDate', $date)->where('class', $class)->where($period, 'Present')->where('Sec', $section)->get();
        // echo '<pre>';print_r($attendance);die();
        if ($attendance->isEmpty()){
            $ress = 'No attendance added';
        } else{
            $ress = 'Attendance added';
        }
        if (!empty($student_list)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'attendance' => $ress,
                'data' => $student_list
            ], 200);
        } else{
            return response()->json([
                'status' => 'success',
                'msg' => 'no matching data found',
                'data' => ''
            ], 200);
        } 
    }
    public function student_dashboard($student_id='')
    {
        if (empty($student_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $students = DB::table('app_studprofile')->select('Name', 'Class', 'Section')->where('SID', $student_id)->first();
         if (!empty($students)) {
                return response()->json([
                'status' => 'success',
                'msg' => 'success',
                'data' => $students
            ], 200);
        } else{
            return response()->json([
                'status' => 'error',
                'msg' => 'not found',
                'data' => ''
            ], 200);
        }  
    }
    public function submit_entry_exitpass(Request $Request)
     {
        $date = $Request->post('date');
        $type = $Request->post('type');
        $student_id = $Request->post('student_id');
        $staff_id = $Request->post('staff_id');
        $reason = $Request->post('reason');
        if (empty($date) || empty($type) || empty($student_id) || empty($staff_id) || empty($reason)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else{
            $std_ids = trim($student_id, '[]');
            $std_ids = explode(',', $std_ids);
            // echo '<pre>';print_r($std_ids);die();
            foreach ($std_ids as $key => $value) {
                $data['stud_id'] = $value;
                $data['date'] = $date;
                $data['type'] = $type;
                $data['staff_id'] = $staff_id;
                $data['reason'] = $reason;
                DB::table('app_entry_exit_card')->insert($data);
            }
            // $data['date'] = $date;
            // $data['type'] = $type;
            // $data['stud_id'] = $student_id;
            // $data['staff_id'] = $staff_id;
            // $data['reason'] = $reason;
            // DB::table('app_entry_exit_card')->insert($data); 
            return response()->json([
                'status' => 'sucess',
                'msg' => 'data inserted successfully',
                'data' => ''
            ], 200);
        }
        
         // echo "hai";die();
     } 
     public function view_pass(Request $Request)
     {
        $staff_id = $Request->post('staff_id');
        $offset = $Request->post('offset');
        $limit = '5';
        if (empty($staff_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }else{
            $reponse =  DB::table('app_entry_exit_card')
            ->select('app_entry_exit_card.*', 'app_studprofile.Name', 'app_studprofile.Class', 'app_studprofile.Section')
            // ->join('app_studprofile', 'app_entry_exit_card.stud_id', '=', 'app_studprofile.SID')
             ->join('app_studprofile', DB::raw('TRIM(app_entry_exit_card.stud_id)'), '=', 'app_studprofile.SID')
            ->where('app_entry_exit_card.staff_id',$staff_id)
            ->skip($offset*$limit)
            ->take($limit)
            ->orderBy('app_entry_exit_card.id', 'desc')
            ->get()
            ->toArray();

            if(!empty($reponse)){
                    return response()->json([
                    'status' => 'success',
                    'msg' => 'success',
                    'data' => $reponse
                ], 200);
            }else{
                return response()->json([
                    'status' => 'success',
                    'msg' => 'no matching data found',
                    'data' => ''
                ], 200);
            }
        }
     }

     public function delete_pass(Request $Request)
     {
        $staff_id = $Request->post('staff_id');
        $gate_pass_id = $Request->post('gate_pass_id');
        if (empty($staff_id) || empty($gate_pass_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else {
            $gatepass = DB::table('app_entry_exit_card')->where('id', $gate_pass_id)->where('staff_id', $staff_id)->first();
            if ($gatepass) {
                DB::table('app_entry_exit_card')->where('id', $gate_pass_id)->where('staff_id', $staff_id)->delete();
                return response()->json([
                    'status' => 'success',
                    'msg' => 'data deleted successfully',
                    'data' => ''
                ], 200);
            } else {
                return response()->json([
                    'status' => 'error',
                    'msg' => 'data not found',
                    'data' => ''
                ], 200);
            }
        }
    }
     public function view_entry_exit_pass(Request $Request)
     {
        $id = $Request->post('id');
        $type = $Request->post('type');
        if (empty($id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }else{
            $reponse = DB::table('app_entry_exit_card')->where('stud_id',$id)->where('type',$type)->orderBy('id', 'desc')->get()->toArray();
            foreach ($reponse as $values) {
                $student = DB::table('app_studprofile')->select('Name','Class','Section')->where('SID', $values->stud_id)->first();
                if ($student) {
                    $values->Name = $student->Name;
                    $values->Class = $student->Class;
                    $values->Section = $student->Section;
                }
            }
            // print_r($reponse);die;
            if(!empty($reponse)){
                    return response()->json([
                    'status' => 'sucess',
                    'msg' => 'successfull',
                    'data' => $reponse,
                ], 200);
                }else{
                    return response()->json([
                    'status' => 'error',
                    'msg' => 'no matching data found',
                    'data' => [],
                ], 200);
            }
            
        }
     }
    public function check_version()
    {
        $version = DB::table('version')->first()->version_no;
        return response()->json([
            'status' => 'success',
            'msg' => 'version',
            'data' => $version
        ], 200);
    }

    public function update_version($ver)
    {
        $res = DB::table('version')->where('id', 1)->update(['version_no'=>$ver]);
        return response()->json([
            'status' => 'success',
            'msg' => 'Version update successfully',
            'data' => ''
        ], 200);
    }

    public function attend_exam_list($studentid='')
    {
        if (empty($studentid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }else{
            $examDetails = DB::table('app_stud_marks_details')->select('examId','subname','totmarks','scoredMarks','studId','attendence_status')->where('studId', $studentid)->get();
            if ($examDetails->isEmpty()) {
                return response()->json([
                    'status' => 'success',
                    'msg' => 'No exam attended',
                    'data' => ''
                ], 200);
            }else{
                $uniqueid = $examDetails->pluck('examId')->unique()->toArray();
                $res = DB::table('appstudent_exam')->select('EId','ExamName')->whereIn('EId',$uniqueid)->get();
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Successfull',
                    'data' => $res,
                ], 200);
                
            }
        }
    }
    public function fee_view_by_id($studentid='')
    {
        if (empty($studentid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => null
            ], 200);
        }else{
            $fee = DB::table('app_fee_collection')->select('class','division','Amount','balance_amount','amount_paid','fineAmount','due_amount','Amt_DueDat')->where('SID', $studentid)->get();
            if ($fee->isEmpty()) {
                return response()->json([
                    'status' => 'success',
                    'msg' => 'No data',
                    'data' => null
                ], 200);
            }else{
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Successfull',
                    'data' => $fee,
                ], 200);
                
            }
        }
    }
    public function view_exam_list_teacher($class='',$section='')
    {
        if (empty($class) || empty($section)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }else{
            $classname = DB::table('app_classname')->where('classId', $class)->first();
            $sectioname = DB::table('app_classdivdetails')->where('classId', $classname->classId)->where('secId', $section)->first();
            $student = DB::table('app_studprofile')->select('SID','Name','Class','Section')->where('Class', $classname->className)->where('Section', $sectioname->secName)->get();
            // print_r($student);die;
                if ($student->isEmpty()) {
                    return response()->json([
                        'status' => 'success',
                        'msg' => 'No students in the given class and section',
                        'data' => '',
                    ], 200);
                }else{
                    foreach ($student as $key => $value) {
                $exam_details = DB::table('app_stud_marks_details')->select('examId','subname','totmarks','scoredMarks','studId','attendence_status')->where('studId', $value->SID)->where('classId', $class)->where('divId', $section)->get();
                $value->examdetails = $exam_details;
            }

            return response()->json([
                'status' => 'success',
                'msg' => 'Successful',
                'data' => $student,
            ], 200);
                }
            
        }
    }
    public function std_markview_by_ids($studentid='',$exam_id='')
    {
        if (empty($studentid) || empty($exam_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }else{
            $examDetails = DB::table('app_stud_marks_details')->select('examId','subname','totmarks','scoredMarks','studId','attendence_status')->where('examId', $exam_id)->where('studId', $studentid)->get();
            // foreach ($examDetails as $key => $value) {
            //     $subject = DB::table('app_sub')->select('Subjects')->where('SubId', $value['subname'])->get()->first();
            // }
            
            if ($examDetails->isEmpty()) {
                return response()->json([
                    'status' => 'success',
                    'msg' => 'No exam attended',
                    'data' => ''
                ], 200);
            }else{
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Successfull',
                    'data' => $examDetails,
                ], 200);
            }
        }
    }
    public function student_mark_view($studentid='')
    {
        if (empty($studentid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $student = DB::table('app_studprofile')->where('SID', $studentid)->first();
        if (!empty($student)) {
            // $res = DB::table('appstudent_exam')->select('EId','ExamName','maxMark')->where('Class', 'like' ,'%' . $student->Class . '%')->get();
            $res = DB::table('appstudent_exam')->select('EId', 'ExamName', 'maxMark')->whereRaw('FIND_IN_SET(?, Class)', [$student->Class])->get();
            // print_r($res->count());die;
            $class = DB::table('app_classname')->where('className',$student->Class)->first();
            $section = DB::table('app_classdivdetails')->where('classId',$class->classId)->where('secName',$student->Section)->first();
            // print_r($res);die;
            if (!$res->isEmpty()) {
                $total = 0;
                $totalscored = 0;
                $exam = [];
                $examDetailsByKey = [];
                $count = 0;
                foreach ($res as $key => $r) {  
                    $examDetails = DB::table('app_stud_marks_details')->select('examId','subname','totmarks','scoredMarks','studId','attendence_status')->where('examId', $r->EId)->where('classId', $class->classId)->where('divId', $section->secId)->where('studId', $student->SID)->get();
                    if (!$examDetails->isEmpty()) {
                        foreach ($examDetails as $detail) {
                            $total += $detail->totmarks;
                            $totalscored += $detail->scoredMarks;
                            
                            $detail->examName = $r->ExamName; 
                            // $detail->examTotalMark = $r->maxMark;
                            $examDetailsByKey[$r->EId][] = $detail;
                            $count = count($examDetailsByKey);
                        }
                        
                    }else {
                        $examDetailsByKey[$r->EId] = [];
                    }  
                }
                // print_r($examDetailsByKey);die;
                return response()->json([
                    'status' => 'success',
                    'msg' => 'Successfull',
                    // 'data' => [ 'exams' => $examDetailsByKey,'examcodes' => $res,'count' => $count,]
                    'data' => [ 'exams' => $examDetailsByKey,'count' => $count,]
                ], 200);
            } else{
                    return response()->json([
                        'status' => 'error',
                        'msg' => 'no data found',
                        'data' => ''
                    ], 200);
            }
        } else{
            return response()->json([
                'status' => 'error',
                'msg' => 'student data not found',
                'data' => ''
            ], 200);
        }
    }
    public function student_curr_view($studentid='')
    {
        if (empty($studentid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $student = DB::table('app_studprofile')->where('SID', $studentid)->first();
        $health = DB::table('app_achievement_health')->where('studid', $studentid)->get()->toArray();
        $lan_speaking = DB::table('app_achievement_language_speakinglistening_skills')->where('studid', $studentid)->get()->toArray();
        $maths_lifestudys = DB::table('app_achievement_maths_lifestudies')->where('studid', $studentid)->get()->toArray();
        $personality = DB::table('app_achievement_personality_development')->where('studid', $studentid)->get()->toArray();

        // $combinedData = DB::table('app_studprofile')
        //     ->select()
        //     ->join('app_achievement_health', 'app_studprofile.term_id', '=', 'app_achievement_health.termid')
        //     ->join('app_achievement_language_speakinglistening_skills', 'app_studprofile.term_id', '=', 'app_achievement_language_speakinglistening_skills.TermId')
        //     ->join('app_achievement_maths_lifestudies', 'app_studprofile.term_id', '=', 'app_achievement_maths_lifestudies.termId')
        //     ->join('app_achievement_personality_development', 'app_studprofile.term_id', '=', 'app_achievement_personality_development.termId')
        //     ->where('app_studprofile.SID', $studentid)
        //     ->where('app_studprofile.term_id', 'T1')
        //     ->get()->toArray();
        // echo "<pre>";print_r($combinedData);die();
        if ($student != '') {
            return response()->json([
                'status' => 'success',
                'msg' => 'Successfull',
                'data' => [
                            'health achievement grades' => $health,
                            'language speaking skill grades' => $lan_speaking,
                            'maths lifestudys grades' => $maths_lifestudys,
                            'personality development grades' => $personality,
                            ]
            ], 200);    
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no data found',
                'data' => ''
            ], 200);
        }
    }
    public function get_student_subjects($studentid='')
    {
        if (empty($studentid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }

        $student = DB::table('app_studprofile')->where('SID', $studentid)->first();
        // $subjects = DB::table('app_sub')->select('subjects')->where('Classes',  'like' ,'%' . $student->Class . '%')->get()->toArray();
        $subjects = DB::table('app_sub')->select('subjects')->whereRaw('FIND_IN_SET(?, Classes)', [$student->Class])->get()->toArray();
        if ($student != '') {
            return response()->json([
                'status' => 'success',
                'msg' => 'Successfull',
                'data' => $subjects,
            ], 200);    
        } else {
            return response()->json([
                'status' => 'error',
                'msg' => 'no data found',
                'data' => ''
            ], 200);
        }
    }

    public function exams_by_classid(Request $req)
    {
        if (empty($req->post('classId'))) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $classid = $req->post('classId');
        $teacher_id = $req->post('teacher_id');
        
        $tech_class = DB::table('app_teacherprofile')->where('TTID',$teacher_id)->value('tech_class');
        if (empty($tech_class)){
            return response()->json([
                'status' => 'error',
                'msg' => 'No classes Assigned ',
                'data' => ''
            ], 200);
        } else {
            $class_data = json_decode($tech_class, true);  
            $class_ids = array_unique(array_column($class_data, 'class'));
            
            $requestedClassId = $req->post('classId');
                
            if (in_array($requestedClassId, $class_ids)) {
                $availableDivisions = array_column(
                    array_filter($class_data, function($item) use ($requestedClassId) {
                        return $item['class'] === $requestedClassId;
                    }),
                    'division'
                );
                $res = DB::table('app_classdivdetails')
                    ->where('classId', $requestedClassId)
                    ->whereIn('secId', $availableDivisions)
                    ->select('secName')
                    ->get();
                    
                
                $class_names = DB::table('app_classname')->where('classid', $classid)->pluck('className')->toArray();
                // echo '<pre>';print_r($class_names);die();
                // $res = DB::table('app_classdivdetails')->where('classId',$req->post('classId'))->select('secName')->get();
                $activeAccYr = DB::table('app_schoolaccyr')->where('status', 1)->pluck('accId')->toArray();
                $exams = DB::table('appstudent_exam')->whereRaw('FIND_IN_SET(?, Class)', [$class_names])->where('accYr',$activeAccYr)->get();
                $subjects = DB::table('app_sub')->whereRaw('FIND_IN_SET(?, Classes)', [$class_names])->get();
        
                return response()->json([
                    'status' => 'success',
                    'msg' => 'get data',
                    'data' => [ 'sections' => $res,'exams' => $exams,'subjects' => $subjects,]
                ], 200);
            }
        }
    }
    public function stud_exams_by_ids(Request $req)
    {
        if (empty($req->post('classId')) || empty($req->post('section_id')) || empty($req->post('subject_id')) || empty($req->post('exam_id'))) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        $classid = $req->post('classId');
        $section_id = $req->post('section_id');
        $subject_id = $req->post('subject_id');
        $subjectDetail = DB::table('app_sub')->where('SubId',$subject_id)->first();
        $classDetail = DB::table('app_classname')->where('className',$classid)->first();
        $exam_id = $req->post('exam_id');
        if (!empty($req->post('classId')) || !empty($req->post('section_id')) || !empty($req->post('subject_id')) || !empty($req->post('exam_id'))) {
            $subject = DB::table('app_sub')->select('Subjects')->where('SubId', $subject_id)->first();
            $exam = DB::table('appstudent_exam')->select('accYr','EId','maxMark')->where('EId', $exam_id)->first();
            $class_id = DB::table('app_classname')->select('classId')->where('className', $classid)->first();
            
            $cls_id = $class_id->classId;
            $section = DB::table('app_classdivdetails')->where('secName', $section_id)->where('classId', $cls_id)->first();
            // $section_id = $section->secId;

            $res = DB::table('app_studprofile')->select('Name','SID','AdmsNo','LocId','Class','Section','rollno')->where('Class', $classid)->where('Section', $section_id)->where('status',1)->orderBy('rollno', 'asc')->get();
            foreach ($res as $key => $value) {
                $scored_marks = DB::table('app_stud_marks_details')->where('examId','LIKE', $exam_id)->where('subname','LIKE', trim($subject->Subjects))->where('studId','LIKE', $value->SID)->where('classId','LIKE',$cls_id)->where('divId','LIKE',$section->secId)->first();
                $res[$key]->section_id = $section->secId;
                $res[$key]->class_id = $class_id->classId; 
                $res[$key]->rollno = $value->rollno;
                if (!empty($scored_marks)) {
                    $res[$key]->scoredMarks = $scored_marks->scoredMarks;
                } else {
                    $res[$key]->scoredMarks = null;
                }
            }
            // print_r($exam);die;
        }else{
            $res = [];
            $exam = null;
        }
        $app_stud_marks_details = DB::table('app_stud_marks_details')->where('classId', $classDetail->classId)->where('examId', $exam_id)->where('subname',$subjectDetail->Subjects)->get();
        if ($app_stud_marks_details->isEmpty()){
            $ress = 'Mark not added';
        } else{
            $ress = 'Mark added';
        }
        return response()->json([
            'status' => 'success',
            'msg' => 'get data',
            'mark' => $ress,
            'data' => ['students' => $res, 'exam' => $exam, 'subject' => $subject],
        ], 200);
    }
    public function exam_mark_add(Request $req)
    {
        $exam_id = $req->post('exam_id');
        $Subject = $req->post('Subject');
        $accYr = $req->post('accYr');
        $maxMark = $req->post('maxMark'); 
        $status = $req->post('status');
        $LocId = $req->post('LocId');
        $Class = $req->post('Class');
        $Section = $req->post('Section'); 
        $fields = $req->post('fields');

        if (empty($fields)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        
        $arrayData = json_decode($fields, true);
        $latestMID = DB::table('app_stud_marks_details')->max('MID');
        $numericMID = intval(substr($latestMID, 3));

        foreach ($arrayData as $key => $val) {
            $data_exist = DB::table('app_stud_marks_details')->where('classId', $Class)->where('divId', $Section)->where('studId', $val['student_id'])->where('examId', $exam_id)->where('subname', $Subject)->first();
            if (!empty($data_exist)) {
                // $data['MId'] = $data_exist->MId;
                $data['scoredMarks'] = $val['score_mark'];
                
                DB::table('app_stud_marks_details')->where('studId', $val['student_id'])->where('examId', $exam_id)->where('subname', $Subject)->where('classId', $Class)->where('divId', $Section)->update($data);
                // print_r($data_exist);die;
            }else{
                $newMID = 'MID' . sprintf("%02d", $numericMID + 1);
                while (DB::table('app_stud_marks_details')->where('MID', $newMID)->exists()) {
                    $numericMID++; 
                    $newMID = 'MID' . sprintf("%02d", $numericMID + 1);
                }
                $data['MID'] = $newMID;
                $data['accId'] = $accYr;
                $data['locId'] = $LocId;
                $data['classId'] = $Class;
                $data['divId'] = $Section;
                $data['studId'] = $val['student_id'];
                $data['admsnNo'] = $val['AdmsNo'];
                $data['studName'] = $val['Name'];
                $data['examId'] = $exam_id;
                $data['subname'] = $Subject;
                $data['attendence_status'] = $status;
                $data['totmarks'] = $maxMark;
                $data['scoredMarks'] = $val['score_mark'];

                DB::table('app_stud_marks_details')->insert($data);
                // print_r($arrayData);die;
                $numericMID++;
            }
        }
        return response()->json([
            'status' => 'success',
            'msg' => 'Mark Added Successfully',
            'data' => ''
        ], 200);


    }
    public function view_mark_pdf($id='')
    {
        $data = [
            'title' => 'Sample PDF',
            'content' => 'This is the content of the PDF.',
        ];

        $pdf = PDF::loadView('view_mark_pdf', $data);

        return $pdf->stream('view_mark_pdf.pdf');
    }

    public function static_periods()
    {
        $data = [
            'periods_count' => 9,
            'periods' => ['P1','P2','P3','P4','P5','P6','P7','P8','P9']
        ];
        return response()->json([
            'status' => 'success',
            'msg' => 'Periods Fetched Successfully',
            'data' => $data
        ], 200);
    }

    public function notStatusUpdate(Request $req)
    {
        $n_id = $req->post('n_id');
        $s_id = $req->post('s_id');
        if (empty($n_id) || empty($s_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }

        $data = DB::table('app_studnotification')->where('NID', $n_id)->first();
        if (!$data) {
            return response()->json([
                'status' => 'error',
                'msg' => 'Notification not found',
                'data' => ''
            ], 200);
        }

        $viewed_ids = explode(',', $data->viewed_ids);
        if (in_array($s_id, $viewed_ids)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'Notification Already Viewed',
                'data' => ''
            ], 200);
        }

        $viewed_ids[] = $s_id;
        DB::table('app_studnotification')->where('NID', $n_id)->update(['viewed_ids' => implode(',', $viewed_ids)]);
        
        return response()->json([
            'status' => 'success',
            'msg' => 'Notification Status Updated Successfully',
            'data' => ''
        ], 200);
    }
    public function StudentNotifCount(Request $req)
    {
        $Sid = $req->post('Sid');
        $Class = $req->post('Class');
        $Sec = $req->post('Sec');
        if (empty($Class)  || empty($Sec) ||  empty($Sid)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        }
        
        $data1 = DB::table('app_studnotification')->select('NID')->where('all_stud', 1)->get();
        $data2 = DB::table('app_studnotification')->select('NID')->where('SID',$Sid)->get();
        $data3 = DB::table('app_studnotification')->select('NID')->where('Class', $Class)->where('Sec',$Sec)->get();

        $merged_array = array_unique(array_merge(
            array_column($data1->toArray(), 'NID'),
            array_column($data2->toArray(), 'NID'),
            array_column($data3->toArray(), 'NID')
        ));
        $count = count($merged_array);
        foreach ($merged_array as $NID) {
            $data = DB::table('app_studnotification')->where('NID', $NID)->first();
            if (in_array($Sid, explode(',', $data->viewed_ids))) {
                $count--;
            } 
        }
        // echo '<pre>';print_r($count);die();
        return response()->json([
            'status' => 'success',
            'msg' => 'Notification Count Fetched Successfully',
            'data' => $count
        ], 200);
        
    }
    public function stdApplyLeave(Request $req)
    {
        $student_id = $req->post('student_id');
        $s_date = $req->post('s_date');
        $e_date = $req->post('e_date');
        $reason = $req->post('reason');
        $class = $req->post('class');
        $section = $req->post('section');
        if (empty($student_id) || empty($s_date) || empty($e_date) || empty($reason) || empty($class) || empty($section)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else {
            $data['student_id'] = $student_id;
            $data['s_date'] = $s_date;
            $data['e_date'] = $e_date;
            $data['reason'] = $reason;
            $data['class'] = $class;
            $data['section'] = $section;
            DB::table('app_leave_requests')->insert($data);
            return response()->json([
                'status' => 'success',
                'msg' => 'Leave Applied Successfully',
                'data' => ''
            ], 200);
        }
    }
    public function studLeaveView($studentid,$status ='')
    {
        $data = DB::table('app_leave_requests')->where('student_id', $studentid);
        if ($status) {
            $data = $data->where('status', $status);
        }
        $data = $data->get();
        if ($data->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'msg' => 'data not found',
                'data' => ''
            ], 200);
        } else {
            return response()->json([
                'status' => 'success',
                'msg' => 'data fetched successfully',
                'data' => $data
            ], 200);
        }
    }
    public function studLeaveViewTeacher($class,$section)
    {
        // $data = DB::table('app_leave_requests')->where('status', 1);
        $data = DB::table('app_leave_requests')->where('class', $class)->where('section', $section)->where('status', 1);
        $data = $data->get();
        if ($data->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'msg' => 'data not found',
                'data' => ''
            ], 200);
        } else {

            foreach ($data as $key => $value) {
                $student_name = DB::table('app_studprofile')->select('Name')->where('SID',$value->student_id)->first();
                $value->student_name = $student_name->Name;
            }
            
            return response()->json([
                'status' => 'success',
                'msg' => 'data fetched successfully',
                'data' => $data
            ], 200);
        }
    }
    public function studLeaveViewTeacherAll($offset = 0)
    {
        $limit = 10;
        $offset = is_numeric($offset) ? (int) $offset : 0;
        $data = DB::table('app_leave_requests as alr')->join('app_studprofile as asp', 'alr.student_id', '=', 'asp.SID')->where('alr.status', 1)->select('alr.*', 'asp.Name as student_name')->skip($offset * $limit)->take($limit)->get();
        if ($data->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'msg' => 'data not found',
                'data' => []
            ], 200);
        }
        return response()->json([
            'status' => 'success',
            'msg' => 'data fetched successfully',
            'data' => $data
        ], 200);
    }

    public function studLeaveStatus(Request $req)
    {
        $leave_id = $req->post('leave_id');
        $status = $req->post('status');
        $teacher_id = $req->post('teacher_id');
        if (empty($leave_id) || empty($status) || empty($teacher_id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else {
            DB::table('app_leave_requests')->where('id', $leave_id)->update(['status' => $status, 'teacher_id' => $teacher_id]);
            return response()->json([
                'status' => 'success',
                'msg' => 'data Updated successfully',
                'data' => ''
            ], 200);
        }

    }
    public function previlageTeacherStaff($id='')
    {
        if (empty($id)) {
            return response()->json([
                'status' => 'error',
                'msg' => 'empty param',
                'data' => ''
            ], 200);
        } else {
            $data = DB::table('app_staffprofile')->where('STID', $id)->first();
            $app_pageprivilages = DB::table('app_pageprivilages')->where('STID',$id)->first();
            if (empty($data)) {
                $data = DB::table('app_teacherprofile')->where('TTID', $id)->first();
                $app_pageprivilages = DB::table('app_pageprivilages')->where('TTID',$id)->first();
            }
            if (empty($data)) {
                return response()->json([
                    'status' => 'error',
                    'msg' => 'data not found',
                    'data' => ''
                ], 200);
            } else {
                $data->pageprivilages = [
                    'attendance_view'         => isset($app_pageprivilages->attendance_view) ? $app_pageprivilages->attendance_view : 0,
                    'attendance_edit'         => isset($app_pageprivilages->attendance_edit) ? $app_pageprivilages->attendance_edit : 0,
                    'mark_edit'               => isset($app_pageprivilages->mark_edit) ? $app_pageprivilages->mark_edit : 0,
                    'mark_view'               => isset($app_pageprivilages->mark_view) ? $app_pageprivilages->mark_view : 0,
                    'entry_exit_card_edit'    => isset($app_pageprivilages->entry_exit_card_edit) ? $app_pageprivilages->entry_exit_card_edit : 0,
                    'entry_exit_card_view'    => isset($app_pageprivilages->entry_exit_card_view) ? $app_pageprivilages->entry_exit_card_view : 0,
                    'healthcard_edit'         => isset($app_pageprivilages->healthcard_edit) ? $app_pageprivilages->healthcard_edit : 0,
                    'healthcard_view'         => isset($app_pageprivilages->healthcard_view) ? $app_pageprivilages->healthcard_view : 0,
                    'event_edit'              => isset($app_pageprivilages->event_edit) ? $app_pageprivilages->event_edit : 0,
                    'event_view'              => isset($app_pageprivilages->event_view) ? $app_pageprivilages->event_view : 0,
                    'leave_edit'              => isset($app_pageprivilages->leave_edit) ? $app_pageprivilages->leave_edit : 0,
                    'leave_view'              => isset($app_pageprivilages->leave_view) ? $app_pageprivilages->leave_view : 0,
                    'payment_edit'            => isset($app_pageprivilages->payment_edit) ? $app_pageprivilages->payment_edit : 0,
                    'payment_view'            => isset($app_pageprivilages->payment_view) ? $app_pageprivilages->payment_view : 0
                ];
                return response()->json([
                    'status' => 'success',
                    'msg' => 'data fetched successfully',
                    'data' => $data
                ], 200);
            }
        }
    }
    
    public function testPush(){
        $data = DB::table('app_studprofile')->where('Class',LIKE, 'XI')->where('Section',LIKE, 'A')->get();
        echo $data->count();
    }
    
}
